Dell Spin To Win Application
=============
<a href="https://laravel.com" target="_blank">Laravel Framework</a> with Nginx, MySQL, PHP (LEMP stack) on Ubuntu 20.04

Architecture follows well-known software patterns and the best security practices. Laravel is a web application framework with expressive, elegant syntax. Clear architecture makes it easy to develop and follow any business requirements. Laravel is accessible, powerful, and provides tools required for large, robust applications.

Development Team Members
------------------------
Amitesh Roy, Deepankar Raizada, Neeraj Kumar

Server Setup
---------------------
* [LEMP Stack](https://www.digitalocean.com/community/tutorials/how-to-install-linux-nginx-mysql-php-lemp-stack-on-ubuntu-20-04)
```console

sudo apt update
sudo apt install nginx
sudo apt install mysql-server
sudo mysql_secure_installation

sudo nano /etc/mysql/mysql.conf.d/mysqld.cnf
bind-address: 0.0.0.0 
sudo systemctl restart mysql

```

* Install PHP 8.1
```console
sudo apt install software-properties-common
sudo add-apt-repository ppa:ondrej/php
sudo apt install php8.1 php8.1-fpm
```

* Php Extensions required
```console

sudo apt install php8.1-mysql php8.1-mbstring php8.1-xml php8.1-zip php8.1-bcmath php8.1-soap php8.1-redis php8.1-dev php8.1-intl php8.1-readline php8.1-curl php8.1-msgpack php8.1-igbinary php8.1-swoole php8.1-memcached php8.1-pcov php8.1-xdebug php-xml php-mbstring php-zip php8.1-imagick

```
* [NGNIX Server](https://www.digitalocean.com/community/tutorials/how-to-install-nginx-on-ubuntu-20-04#step-5-%E2%80%93-setting-up-server-blocks-(recommended)) Initial configuration
```console
sudo rm /etc/nginx/sites-enabled/default

sudo nano /etc/nginx/conf.d/dellspintowin.com.conf
server {
  listen 80;
  listen [::]:80;

  root /home/ubuntu/apps/dellspintowin.com;
  index index.html index.htm index.php;

  server_name dellspintowin.com www.dellspintowin.com;

  location / {
    try_files $uri $uri/ =404;
  }

  location ~ \.php$ {
    include snippets/fastcgi-php.conf;
    fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
  }

  location ~ /\.ht {
    deny all;
  }
}

sudo nano /etc/nginx/nginx.conf 
user ubuntu; #Change from www-data to ubuntu 

sudo nginx -t
sudo systemctl restart nginx

sudo nano /etc/php/8.1/fpm/pool.d/www.conf 
user: ubuntu #Change from www-data to ubuntu 
group: ubuntu #Change from www-data to ubuntu 
listener.group: ubuntu 
listener.user: ubuntu 

sudo service php8.1-fpm restart

```


 * Install [Composer](https://www.digitalocean.com/community/tutorials/how-to-install-composer-on-ubuntu-20-04-quickstart)
 ```console

sudo apt update
sudo apt install php-cli unzip
curl -sS https://getcomposer.org/installer -o /tmp/composer-setup.php
HASH=`curl -sS https://composer.github.io/installer.sig`
php -r "if (hash_file('SHA384', '/tmp/composer-setup.php') === '$HASH') { echo 'Installer verified'; } else { echo 'Installer corrupt'; unlink('composer-setup.php'); } echo PHP_EOL;"
sudo php /tmp/composer-setup.php --install-dir=/usr/local/bin --filename=composer
```

 * Install [LetsEncrypt Certificate](https://www.digitalocean.com/community/tutorials/how-to-secure-nginx-with-let-s-encrypt-on-ubuntu-20-04)
 ```console 
 
sudo apt install certbot python3-certbot-nginx
sudo certbot --nginx -d dellspintowin.com -d www.dellspintowin.com

 ```

 * Setup SSH Deployment keys 
```console
ssh-keygen -t rsa-sha2-512 -C "draizada@outlook.com"
```
* Install [Laravel](https://www.digitalocean.com/community/tutorials/how-to-install-and-configure-laravel-with-lemp-on-ubuntu-18-04)
```console
mkdir ~/apps && cd ~/apps 
rm -Rf dellspintowin.com
git clone --branch barcelona git@ssh.dev.azure.com:v3/Snpl/Timeus/dellspintowinuk.com dellspintowin.com

```
* Update NGNIX configuration file
```console
server {

    root /home/ubuntu/apps/dellspintowin.com/public;
    index index.html index.htm index.php;

    server_name dellspintowin.com www.dellspintowin.com;
        
    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-XSS-Protection "1; mode=block";
    add_header X-Content-Type-Options "nosniff";

    charset utf-8;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location = /favicon.ico { access_log off; log_not_found off; }
    location = /robots.txt  { access_log off; log_not_found off; }

    error_page 404 /index.php;

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\.ht {
        deny all;
    }
    location ~ /\.(?!well-known).* {
        deny all;
    }

    listen [::]:443 ssl ipv6only=on; # managed by Certbot
    listen 443 ssl; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/dellspintowin.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/dellspintowin.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot
}
server {
    if ($host = www.dellspintowin.com) {
        return 302 https://$host$request_uri;
    } # managed by Certbot

    if ($host = dellspintowin.com) {
        return 301 https://www.$host$request_uri;
    } # managed by Certbot

    listen 80;
    listen [::]:80;

    server_name dellspintowin.com www.dellspintowin.com;
    return 404; # managed by Certbot
}
```

* Create database
```console
sudo mysql
CREATE DATABASE spintowin;
CREATE USER 'spintowin'@'localhost' IDENTIFIED WITH mysql_native_password BY 'spintowin@25';
GRANT ALL ON spintowin.* TO 'spintowin'@'localhost';

FLUSH PRIVILEGES;

```

* Set php default version 
```console
sudo update-alternatives --config php
```

* Update .env and composer
```console
composer install --optimize-autoloader --no-dev
```

* Rerun deployment optimization
```console

git pull origin barcelona && composer install --optimize-autoloader --no-dev && php artisan migrate && php artisan optimize:clear && php artisan optimize

```

* Queries
```console

select id, name, max_allowed_per_hour, max_allowed_total,total_allocated_count from prizes;

sudo mysqldump spintowin > db.sql


```
