<?php

namespace App\Console\Commands\Application;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class Reset extends Command
{

    private $progressBar;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:reset';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reset the prize distribution';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->newLine();
        $this->error('+----------------------+');
        $this->error('| BE EXTREMELY CAREFUL |');
        $this->error('+----------------------+');
        $this->newLine();
        $this->error('This command will clear everything and install a fresh copy. Please use with extreme caution.');

        $response = $this->confirm('Are you sure you want to continue? This action cannot be undone.');

        if (!$response) {
            $this->info('Cancelled Installation.');
            return 0;
        }

        $this->progressBar = $this->output->createProgressBar(3);

        $this->info('Installation started');
        $this->progressBar->advance();

        $this->clearDatabase();
        $this->progressBar->advance();

        $this->seedDatabase();
        $this->progressBar->finish();

        return 0;
    }

    private function clearDatabase()
    {
        $this->info('Deleting old database and installing fresh copy');
        Artisan::call('migrate:fresh');
        $this->progressBar->advance();
    }

    private function seedDatabase()
    {
        $this->info('Seeding default data');
        Artisan::call('db:seed');
        $this->progressBar->advance();
    }
}
