<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PlayerWon
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $player;

    public $prize;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($player, $prize)
    {
        $this->player = $player;
        $this->prize = $prize;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
