<?php

namespace App\Jobs;

use App\Mail\PrizeWonMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendPrizeWonEmail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $player;

    public $prize;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($player, $prize)
    {
        $this->player = $player;
        $this->prize = $prize;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        Mail::to($this->player->email)->send(new PrizeWonMail($this->player, $this->prize));
    }
}