<?php

namespace App\Listeners;

use App\Events\PlayerWon;
use App\Mail\PrizeWonMail;
use Illuminate\Support\Facades\Mail;

class SendPrizeWonNotification
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\PlayerWon  $event
     * @return void
     */
    public function handle(PlayerWon $event)
    {
        Mail::to($event->player->email)->send(new PrizeWonMail($event->player, $event->prize));
    }
}