<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PrizeWonMail extends Mailable
{
    use Queueable, SerializesModels;

    public $player;

    public $prize;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($player, $prize)
    {
        $this->player = $player;
        $this->prize = $prize;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Congratulations on winning Spin To Win! #DellTechForum')->view('emails.prizewon')
            ->with([
                'player' => $this->player,
                'prize' => $this->prize,
            ]);
    }
}