<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrizeDistributionConfiguration extends Model
{
    use HasFactory;

    protected $table = 'prize_distribution_configuration';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
      'key',
      'value'
    ];

    public  static function keyExists($key)
    {
        //return key value
        return PrizeDistributionConfiguration::where('key', $key)->count() > 0;
    }

    public  static function findKeyValue($key)
    {
        //return key value
        return PrizeDistributionConfiguration::where('key', $key)->first()->value;
    }

    public  static function setKeyValue($key, $value)
    {
        // set the key value
        PrizeDistributionConfiguration::updateOrCreate(['key' => $key], ['value' => $value]);
    }
}
