<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Str;

class OnlyDell implements Rule
{

    private $emails = [
        'dell.com',
        'dellteam.com',
        'timeus.in',
        'netsouls.net'
    ];

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $x = explode('@', Str::lower($value));
        $domain = array_pop($x);
        return in_array($domain, $this->emails);

    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Only domains with dell.com and dellteam.com can participate';
    }
}