<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prize_distribution', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('prize_id')->nullable();
            $table->unsignedBigInteger('player_id')->nullable();
            $table->integer('selected_day')->nullable();
            $table->timestamps();

            $table->foreign('prize_id')->references('id')->on('prizes');
            $table->foreign('player_id')->references('id')->on('players');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prize_distribution');
    }
};
