<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PrizeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $prizeData = [
            [
                'name' => 'Notepad',
                'title' => 'Notepad',
                'description' => 'Elegant and functional notepad',
                'max_allowed_total' => 200,
                'max_allowed_per_day' => 100,
                'max_allowed_per_hour' => 14,
                'total_allocated_count' => 0,
                'degree' => 180,
                'display_order' => 1,
                'created_at' => now(), 'updated_at' => now()
            ],
            [
                'name' => 'Pen',
                'title' => 'Pen',
                'description' => 'An elegant and stylish pen for your desk.',
                'max_allowed_total' => 250,
                'max_allowed_per_day' => 125,
                'max_allowed_per_hour' => 7,
                'total_allocated_count' => 0,
                'degree' => 135,
                'display_order' => 3,
                'created_at' => now(), 'updated_at' => now()
            ],
            [
                'name' => 'Adapter',
                'title' => 'Adapter',
                'description' => 'Power up your devices with a handy and functional adapter.',
                'max_allowed_total' => 99,
                'max_allowed_per_day' => 50,
                'max_allowed_per_hour' => 5,
                'total_allocated_count' => 0,
                'degree' => 270,
                'display_order' => 3,
                'created_at' => now(), 'updated_at' => now()
            ],
            [
                'name' => 'Pop Grip',
                'title' => 'Pop Grip',
                'description' => 'Add a touch of style and functionality to your phone with a cool Pop Grip.',
                'max_allowed_total' => 150,
                'max_allowed_per_day' => 75,
                'max_allowed_per_hour' => 10,
                'total_allocated_count' => 0,
                'degree' => 90,
                'display_order' => 4,
                'created_at' => now(), 'updated_at' => now()
            ],
            [
                'name' => 'Stainless Steel Tumbler',
                'title' => 'Stainless Steel Tumbler',
                'description' => 'Enjoy your favourite drinks on the go with this cool stainless-steel tumbler.',
                'max_allowed_total' => 50,
                'max_allowed_per_day' => 25,
                'max_allowed_per_hour' => 3,
                'total_allocated_count' => 0,
                'degree' => 220,
                'display_order' => 5,
                'created_at' => now(), 'updated_at' => now()
            ],
            [
                'name' => 'McLaren Lego Set',
                'title' => 'McLaren Lego Set',
                'description' => 'Speed into the world of Formula 1 racing with the supercool McLaren Lego kit.',
                'max_allowed_total' => 14,
                'max_allowed_per_day' => 7,
                'max_allowed_per_hour' => 1,
                'total_allocated_count' => 0,
                'degree' => 40,
                'display_order' => 6,
                'created_at' => now(), 'updated_at' => now()
            ],
            [
                'name' => 'Dell Backpack',
                'title' => 'Dell Backpack',
                'description' => 'Carry your style everywhere with this cool Dell Backpack.',
                'max_allowed_total' => 14,
                'max_allowed_per_day' => 7,
                'max_allowed_per_hour' => 1,
                'total_allocated_count' => 0,
                'degree' => 310,
                'display_order' => 7,
                'created_at' => now(), 'updated_at' => now()
            ],
            [
                'name' => 'Free Spin',
                'title' => 'Try Again',
                'description' => 'Try Again',
                'max_allowed_total' => 1000,
                'max_allowed_per_hour' => 1000,
                'max_allowed_per_day' => 1000,
                'total_allocated_count' => 0,
                'degree' => 360,
                'display_order' => 8,
                'created_at' => now(), 'updated_at' => now()
            ]
        ];
        DB::table('prizes')->insert($prizeData);
    }
}
