@extends('layouts.app')
@section('content')
    <article class="content d-flex justify-content-center align-items-center">
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="spine1bg text-center">
                    <div>
                        <img src="{{ asset('images/home-wheel-small.png') }}" alt="" title=""
                            class="img-fluid smalldesktop">
                        <img src="{{ asset('images/home-wheel-large.png') }}" alt="" title=""
                            class="img-fluid bigdesktop">
                    </div>
                    <div class="btn1 mt-22"> <a data-bs-toggle="modal" data-bs-target="#popuptnc">Play Game</a> </div>
                </div>
            </div>
        </div>
    </article>
@endsection

@section('modals')
    <!-- Modal T&C-->
    <div class="mainpopup">
        <div class="modal fade" data-bs-keyboard="false" data-bs-backdrop="static" tabindex="-1"
            aria-labelledby="popuptncLabel" aria-hidden="true" id="popuptnc">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><img
                                src="{{ asset('images/close.png') }}" class="img-fluid"></button>
                    </div>
                    <div class="modal-body">
                        <div class="popuptncdetail">
                            <div class="tncimg"> </div>
                             <div class="tncdetailbox">
                                <h2>T&amp;Cs </h2>
                                <div class="heightfix">
                                    <ul>
                                        <li>The Promoter of this Prize Draw is Dell Corporation Limited, with its registered
                                            office address at: 1st &amp; 2nd Floor, One Creechurch Place, London, EC3A 5AF.</li>
                                        <li>This Prize Draw will be governed by these terms and conditions. By means of
                                            their
                                            participation in this Prize Draw, entrants confirm that they have read and agree
                                            to these terms and conditions. </li>
                                        <li>This Prize Draw is open to UK residents aged 18 and over only excluding
                                            employees and
                                            immediate relatives of employees of the Promoter, its parent, subsidiaries or
                                            affiliated
                                            companies or any other person professionally connected with this Prize Draw.
                                        </li>
                                        <li>Participation is permitted irrespective of purchase of a product/service. No
                                            purchase necessary. </li>
                                        <li>One (1) entry per individual and per email address is permitted. </li>
                                        <li>In case of non-compliance with any of these rules or any behavior that is
                                            considered
                                            defamatory, offensive, or illegal, the Promoter reserves the right to reject the
                                            entrant from
                                            the Prize Draw. </li>
                                        <li>The Promoter takes no responsibility for entries that are lost, delayed,
                                            misdirected or
                                            incomplete or cannot be delivered or entered for any technical or other reason.
                                            Proof of
                                            delivery of the entry is not proof of receipt. </li>
                                    </ul>

                                    <p class="text-white p-3" style="font-size:0.9rem;"><a href="prize-draw-terms-conditions.pdf" target="_blank" class="text-white">Click here</a> to view the full  Terms &amp; Conditions.</p>

                                </div>
                                <div class="mt-1">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="tnc_check" required="" checked>
                                        <label class="form-check-label" for="tnc_check"> I agree to the terms &amp; conditions.</label>
                                        <label class="form-check-label invalid-feedback" id="tnc_validation" style="display: none;">Please accept the terms and conditions.</label>
                                    </div>
                                </div>
                                <div class="btn1 mt-4"> <a id="btn_tnc_check">Agree</a> </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal T&C-->
@endsection

@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#btn_tnc_check').click(function(evt) {
                if (!$('#tnc_check').is(':checked')) {
                    evt.preventDefault();
                    $('#tnc_validation').show();
                } else {
                    // dismiss this modal and register the player
                    fetch("{{ route('player.register') }}", {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest',
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        }).then(response => response.json())
                        .then(data => {
                            $('#popuptnc').modal('toggle');
                          //  alert(data.message);
                            window.location.href = data.redirect_url;
                        }).catch((error) => {
                            console.log(error);
                        });
                }
            })
        });
    </script>
@endsection
