@extends('layouts.admin')
@section('content')
<div class="col-xl-12 col-lg-6 col-md-12 col-sm-12">
    <div class="tab-content p-3">
        <div id="home" class="tab-pane fade-in active">
            @if (session('user-delete-status'))
            <p class="invalid-feedback">{{ session('user-delete-status') }}</p>
            @endif
            <h3 class="tab-heading">At a Glance</h3>
            <div id="totalStats">
                @include('web-admin._stats')
            </div>
            <div class="row mt-3">
                <div class="col-lg-12">
                    <h3>Stimulator</h1>
                        <div class="row">
                            <div class="col-12">
                                <form class="form-card" onsubmit="event.preventDefault()">
                                    <div class="row justify-content-between text-left">
                                        <input type="hidden" name="day" id="day" value="1">
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                            <label class="form-control-label px-3">Iterations<span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" name="iterations" id="iterations" required>
                                                @for ($i = 50; $i <= 300; $i = $i + 50) <option value="{{ $i }}">{{ $i }}
                                                    </option>
                                                    @endfor
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row justify-content-end mt-3">
                                        <div class="form-group col-sm-12">
                                            <button type="submit" id="btnStimulate"
                                                class="btn btn-warning">Stimulate</button>
                                            <a href="{{ route('admin.reset') }}" class="btn btn-danger">Reset</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-6">
                                <div id="prizes_first"></div>
                            </div>
                            <div class="col-6">
                                <div id="prizes_last"></div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {

        //we will iterate through the count and setup the ajax call to find the prize distribution
        $('#btnStimulate').click(function(evt) {
            evt.preventDefault();
            $(this).attr('disabled','disabled');

            processQueries($('#iterations').val());
        });
    });

    var apiUrl = "{{ route('admin.stimulator', [':day']) }}";

    async function processQueries(count) {
        for (let i = 1; i <= count; i++) {
            //we will iterate through the count and setup the ajax call to find the prize distribution
            await processQuery(i);
        }
        // reset the stats
        fetch("{{ route('admin.dashboard') }}", {
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        }).then(response => response.text())
        .then(data => {
            $('#totalStats').html(data);
            $('#btnStimulate').removeAttr('disabled');
        }).catch((error) => {
            console.log(error);
        });
    }

    function processQuery(i) {
        return new Promise((resolve, reject) => {
            fetch(apiUrl.replace(':day',$('#day').val()), {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).then(response => response.json())
            .then(data => {
                // set the prize distribution in html
                divId = i % 2 === 0 ? '#prizes_last' : '#prizes_first';
                $(divId).append(i + ': ' + data.name + '<br/>');
                resolve(i);
            }).catch((error) => {
                console.log(error);
            });
        });
    }
</script>
@endsection
