@extends('layouts.admin')
@section('content')
    <div class="col-xl-12 col-lg-6 col-md-12 col-sm-12">
        <div class="tab-content p-3">
            <div class="row">
                <div class="col-lg-6 mt-4">
                    <form method="POST" action="{{ route('admin.login.post') }}">
                        @csrf
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="row">
                            <div class="mb-3 form-group">
                                <label class="form-label" for="userName">Your username</label>
                                <input class="form-control" tabindex="1" placeholder="Enter username" id="userName"
                                    name="userName" autocomplete="off" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 form-group">
                                <label class="form-label" for="password">Your password</label>
                                <input type="password" class="form-control" tabindex="2" required
                                    placeholder="Enter Pasword" id="password" name="password" autocomplete="off">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
