<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [App\Http\Controllers\GameController::class,'index'])->name('home');
Route::post('/register', [App\Http\Controllers\GameController::class,'register_player'])->name('player.register');


Route::get('/puzzle/{uuid}/{step}', [App\Http\Controllers\GameController::class,'puzzle'])->name('player.puzzle');
Route::get('/puzzle/{uuid}', [App\Http\Controllers\GameController::class,'puzzlePost'])->name('player.puzzle.submit');

Route::get('/game/{uuid}', [App\Http\Controllers\GameController::class,'game'])->name('player.game');

Route::post('/game/prize', [App\Http\Controllers\GameController::class,'store_game_prize'])->name('player.game.prize');

Route::get('/thank-you', function() {
    return view('thanks');
})->name('player.game.thank');

Route::get('/game-over', function() {
    return view('game-over');
})->name('game-over');

// admin login
Route::get('/web-admin', function (Request $request) {
    $request->session()->put('admin.username', '');
    return view('web-admin.index');
})->name('admin.login');

Route::post('/web-admin', [App\Http\Controllers\WebAdminController::class,'login'])->name('admin.login.post');

Route::group([
    'prefix' => 'web-admin',
    'middleware' => 'IsAdmin'
], function() {
    // dashboard
    Route::get('/dashboard', [\App\Http\Controllers\WebAdminController::class,'index'])->name('admin.dashboard');
    Route::get('/report', [App\Http\Controllers\WebAdminController::class,'getReport'])->name('admin.report');
    Route::post('/stimulate/{day}', [App\Http\Controllers\WebAdminController::class,'prizeStimulator'])->name('admin.stimulator');
    Route::get('/reset', [App\Http\Controllers\WebAdminController::class,'resetPrizes'])->name('admin.reset');
});
