<?php $__env->startSection('content'); ?>
<div class="col-xl-12 col-lg-6 col-md-12 col-sm-12">
    <div class="tab-content p-3">
        <div id="home" class="tab-pane fade-in active">
            <?php if(session('user-delete-status')): ?>
            <p class="invalid-feedback"><?php echo e(session('user-delete-status')); ?></p>
            <?php endif; ?>
            <h3 class="tab-heading">At a Glance</h3>
            <div id="totalStats">
                <?php echo $__env->make('web-admin._stats', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="row mt-3">
                <div class="col-lg-12">
                    <h3>Stimulator</h1>
                        <div class="row">
                            <div class="col-12">
                                <form class="form-card" onsubmit="event.preventDefault()">
                                    <div class="row justify-content-between text-left">
                                        <input type="hidden" name="day" id="day" value="1">
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                            <label class="form-control-label px-3">Iterations<span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" name="iterations" id="iterations" required>
                                                <?php for($i = 50; $i <= 300; $i = $i + 50): ?> <option value="<?php echo e($i); ?>"><?php echo e($i); ?>

                                                    </option>
                                                    <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row justify-content-end mt-3">
                                        <div class="form-group col-sm-12">
                                            <button type="submit" id="btnStimulate"
                                                class="btn btn-warning">Stimulate</button>
                                            <a href="<?php echo e(route('admin.reset')); ?>" class="btn btn-danger">Reset</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-6">
                                <div id="prizes_first"></div>
                            </div>
                            <div class="col-6">
                                <div id="prizes_last"></div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
    $(document).ready(function() {

        //we will iterate through the count and setup the ajax call to find the prize distribution
        $('#btnStimulate').click(function(evt) {
            evt.preventDefault();
            $(this).attr('disabled','disabled');

            processQueries($('#iterations').val());
        });
    });

    var apiUrl = "<?php echo e(route('admin.stimulator', [':day'])); ?>";

    async function processQueries(count) {
        for (let i = 1; i <= count; i++) {
            //we will iterate through the count and setup the ajax call to find the prize distribution
            await processQuery(i);
        }
        // reset the stats
        fetch("<?php echo e(route('admin.dashboard')); ?>", {
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        }).then(response => response.text())
        .then(data => {
            $('#totalStats').html(data);
            $('#btnStimulate').removeAttr('disabled');
        }).catch((error) => {
            console.log(error);
        });
    }

    function processQuery(i) {
        return new Promise((resolve, reject) => {
            fetch(apiUrl.replace(':day',$('#day').val()), {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).then(response => response.json())
            .then(data => {
                // set the prize distribution in html
                divId = i % 2 === 0 ? '#prizes_last' : '#prizes_first';
                $(divId).append(i + ': ' + data.name + '<br/>');
                resolve(i);
            }).catch((error) => {
                console.log(error);
            });
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Dhiraj Work\#Website Projects\2025\Dell\Build to Win\Laravel 2\resources\views/web-admin/dashboard.blade.php ENDPATH**/ ?>